/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.core.model;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import me.jellysquid.mods.sodium.client.world.biome.BlockColorsExtended;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BlockColors.class})
public class MixinBlockColors
implements BlockColorsExtended {
    private Reference2ReferenceMap<Block, IBlockColor> blocksToColor;
    private static final IBlockColor DEFAULT_PROVIDER = (state, view, pos, tint) -> -1;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void init(CallbackInfo ci) {
        this.blocksToColor = new Reference2ReferenceOpenHashMap();
        this.blocksToColor.defaultReturnValue((Object)DEFAULT_PROVIDER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"registerBlockColorHandler"}, at={@At(value="HEAD")})
    private void preRegisterColor(IBlockColor provider, Block[] blocks, CallbackInfo ci) {
        Reference2ReferenceMap<Block, IBlockColor> reference2ReferenceMap = this.blocksToColor;
        synchronized (reference2ReferenceMap) {
            for (Block block : blocks) {
                if (provider == null) continue;
                this.blocksToColor.put((Object)block, (Object)provider);
            }
        }
    }

    @Override
    public IBlockColor getColorProvider(IBlockState state) {
        return (IBlockColor)this.blocksToColor.get((Object)state.func_177230_c());
    }

    @Override
    public boolean hasColorProvider(IBlockState state) {
        return this.blocksToColor.get((Object)state.func_177230_c()) != DEFAULT_PROVIDER;
    }
}

